<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle ?? 'Sierro Engenharia'; ?></title>
    <!-- Favicons -->
<link rel="icon" href="images/favicon.ico" sizes="any">
<link rel="icon" type="image/png" sizes="16x16" href="images/favicon-16x16.png">
<link rel="icon" type="image/png" sizes="32x32" href="images/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="512x512" href="images/favicon-512x512.png">

<!-- Para dispositivos Apple (recomendável adicionar) -->
<link rel="apple-touch-icon" sizes="180x180" href="images/favicon-512x512.png">

<!-- Manifest para PWA e resultados de busca aprimorados -->
<link rel="manifest" href="manifest.json">
<meta name="theme-color" content="#00214e">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <!-- Seu CSS customizado -->
    <link rel="stylesheet" href="css/style.css">
    
    <!-- AOS e Swiper -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    
    <!-- GTranslate Settings -->
    <script>
        window.gtranslateSettings = {
            "default_language": "pt",
            "detect_browser_language": true,
            "languages": ["pt", "en", "es"],
            "wrapper_selector": ".gtranslate_wrapper",
            "flag_style": "3d",
            "alt_flags": {
                "en": "usa",
                "pt": "brazil",
                "es": "argentina"
            }
        }
    </script>
    <!-- Schema.org para resultados de pesquisa aprimorados -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "Sierro Engenharia",
  "url": "https://sierroengenharia.com.br/",
  "logo": "https://sierroengenharia.com.br/images/favicon-512x512.png",
  "image": "https://sierroengenharia.com.br/images/logo.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "+551983838641",
    "contactType": "customer service"
  }
}
</script>
    <script src="https://cdn.gtranslate.net/widgets/latest/flags.js" defer></script>
</head>
<body>
    <!-- Top Bar -->
    <div class="top-bar">
        <div class="container">
            <div class="top-bar-content">
                <div class="top-bar-left">
                    <span class="datetime">
                        <i class="far fa-clock"></i>
                        <?php 
    date_default_timezone_set('America/Sao_Paulo');
    echo date('Y-m-d H:i:s') . ' (Horário de Brasília)'; 
?>
                    </span>
                </div>
                <div class="operational-contacts">
                    <span class="contact-label">Operacional:</span>
                    <a href="mailto:flaviopiza@sierroengenharia.com.br" class="top-email">
                        <i class="fas fa-envelope"></i>
                        flaviopiza@sierroengenharia.com.br
                    </a>
                    <a href="mailto:t.sierro@sierroengenharia.com.br" class="top-email">
                        <i class="fas fa-envelope"></i>
                        t.sierro@sierroengenharia.com.br
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Header Principal -->
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <img src="images/logo.png" alt="Sierro Engenharia" class="logo-img">
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" 
                    data-bs-target="#navbarNav" aria-controls="navbarNav" 
                    aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="quem-somos.php">Quem Somos</a>
                    </li>
                    
                    <li class="nav-item">
                        <a class="nav-link" href="equipamentos.php">Equipamentos</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="galeria.php">Galeria</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contato.php">Contato</a>
                    </li>
                </ul>

                <!-- GTranslate -->
                <div class="lang-selector">
                    <div class="gtranslate_wrapper"></div>
                </div>
            </div>
        </div>
    </nav>

    <!-- Bootstrap JS e Popper.js -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js"></script>

    <!-- Menu Mobile Script -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const navLinks = document.querySelectorAll('.nav-link');
        const navbarCollapse = document.querySelector('.navbar-collapse');
        
        if (navLinks && navbarCollapse) {
            navLinks.forEach(link => {
                link.addEventListener('click', () => {
                    if (navbarCollapse.classList.contains('show')) {
                        navbarCollapse.classList.remove('show');
                    }
                });
            });
        }
    });
    </script>
    
    <style>
    /* Estilos para o GTranslate */
    .lang-selector {
        margin-left: 20px;
    }
    
    .gtranslate_wrapper {
        display: flex;
        align-items: center;
    }
    
    /* Override dos estilos do GTranlate para corresponder ao seu site */
    .gt_float_switcher img {
        width: 24px !important;
        height: 24px !important;
        margin: 0 5px !important;
        border-radius: 50%;
        transition: transform 0.3s ease;
    }
    
    .gt_float_switcher img:hover {
        transform: scale(1.2);
        cursor: pointer;
    }
    </style>