<?php 
$pageTitle = 'Café e Leite - Sierro Engenharia';
include 'header.php'; 
?>

<!-- Hero Section -->
<section class="hero-banner">
    <div class="container">
        <div class="hero-content">
            <h1 class="animate-up">Soluções para Café e Leite</h1>
            <div class="hero-divider animate-up"></div>
            <p class="hero-subtitle animate-up">Tecnologia avançada em processamento e secagem</p>
        </div>
    </div>
</section>

<!-- Conteúdo Principal -->
<main class="main-content">
    <div class="container">
        <!-- Grid Principal -->
        <div class="content-grid">
            <!-- Coluna de Texto -->
            <div class="text-column" data-aos="fade-right">
                <div class="text-content">
                    <div class="text-block">
                        <div class="section-tag">Tecnologia Avançada</div>
                        <p>
                            Utilizando as mais avançadas tecnologias de Secagem, Extração e Processamento, nossos equipamentos são projetados para garantir que todo o potencial do produto (matérias-primas) seja extraído com precisão e qualidade.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Soluções Completas</div>
                        <p>
                            Nosso compromisso com a inovação e a excelência tecnológica nos permite oferecer soluções completas para o desenvolvimento de equipamentos destinados à produção de café solúvel, leite em pó, chá, extratos e essências, entre outros produtos relacionados.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Projetos Personalizados</div>
                        <p>
                            Cada projeto é cuidadosamente elaborado para atender às necessidades específicas de nossos clientes, assegurando eficiência operacional, qualidade do produto final e sustentabilidade nos processos.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Compromisso Sierro</div>
                        <p>
                            Desde a fase de concepção até a implementação final, a Sierro Engenharia trabalha em estreita colaboração com os clientes para entregar soluções personalizadas, com o objetivo de aumentar a produtividade e reduzir os custos operacionais.
                        </p>
                    </div>

                    <!-- Cards de Produtos -->
                    <div class="products-grid">
                        <div class="product-card" data-aos="fade-up">
                            <div class="product-icon">
                                <i class="fas fa-coffee"></i>
                            </div>
                            <h3>Café Solúvel</h3>
                            <p>Equipamentos especializados para produção de café solúvel</p>
                        </div>

                        <div class="product-card" data-aos="fade-up" data-aos-delay="100">
                            <div class="product-icon">
                                <i class="fas fa-glass-milk"></i>
                            </div>
                            <h3>Leite em Pó</h3>
                            <p>Soluções avançadas para processamento de leite</p>
                        </div>

                        <div class="product-card" data-aos="fade-up" data-aos-delay="200">
                            <div class="product-icon">
                                <i class="fas fa-leaf"></i>
                            </div>
                            <h3>Chá e Extratos</h3>
                            <p>Tecnologia de ponta para extratos e essências</p>
                        </div>
                    </div>

                    <!-- Botão de Orçamento -->
                    <div class="cta-wrapper">
                        <a href="contato.php" class="cta-button">
                            <span>Solicitar Orçamento</span>
                            <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Coluna da Imagem -->
            <div class="image-column" data-aos="fade-left">
                <div class="image-sticky">
                    <div class="main-image">
                        <img src="images/cafe_soluvel.png" alt="Processamento de Café e Leite">
                        <div class="image-overlay">
                            <div class="specs-list">
                                <div class="spec-item">
                                    <i class="fas fa-cog"></i>
                                    <span>Tecnologia Avançada</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-chart-line"></i>
                                    <span>Alta Produtividade</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-leaf"></i>
                                    <span>Processos Sustentáveis</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Indicadores de Performance -->
                    <div class="performance-indicators">
                        <div class="indicator" data-aos="fade-up">
                            <div class="indicator-value">100%</div>
                            <div class="indicator-label">Customização</div>
                        </div>
                        <div class="indicator" data-aos="fade-up" data-aos-delay="100">
                            <div class="indicator-value">99%</div>
                            <div class="indicator-label">Eficiência</div>
                        </div>
                        <div class="indicator" data-aos="fade-up" data-aos-delay="200">
                            <div class="indicator-value">24/7</div>
                            <div class="indicator-label">Suporte</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
/* Hero Banner */
.hero-banner {
    background: linear-gradient(45deg, #00214e, #003175);
    padding: 100px 0;
    color: white;
    position: relative;
    overflow: hidden;
}

.hero-banner::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 50%;
    height: 100%;
    background: url('assets/images/pattern.png') repeat;
    opacity: 0.1;
}

.hero-content {
    text-align: center;
    position: relative;
    z-index: 2;
}

.hero-content h1 {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 20px;
}

.hero-divider {
    width: 100px;
    height: 4px;
    background: #e4451d;
    margin: 0 auto 20px;
}

.hero-subtitle {
    font-size: 1.5rem;
    opacity: 0.9;
}

/* Layout Principal */
.main-content {
    padding: 80px 0;
    background: #f8f9fa;
}

.container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 20px;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 60px;
    align-items: start;
}

/* Texto e Conteúdo */
.text-column {
    padding-right: 40px;
}

.text-content {
    background: white;
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.text-block {
    margin-bottom: 40px;
}

.text-block p {
    font-size: 1.2rem;
    line-height: 1.8;
    color: #444;
    text-align: justify;
    text-justify: inter-word;
    margin: 0;
}

.section-tag {
    display: inline-block;
    padding: 8px 16px;
    background: #fff2f0;
    color: #e4451d;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 500;
    margin-bottom: 15px;
}

/* Cards de Produtos */
.products-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    margin: 40px 0;
}

.product-card {
    background: #f8f9fa;
    padding: 30px;
    border-radius: 15px;
    text-align: center;
    transition: all 0.3s ease;
}

.product-card:hover {
    transform: translateY(-10px);
    background: #fff2f0;
}

.product-icon {
    width: 60px;
    height: 60px;
    background: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 15px;
}

.product-icon i {
    font-size: 24px;
    color: #e4451d;
}

.product-card h3 {
    color: #00214e;
    margin-bottom: 10px;
    font-size: 1.2rem;
}

.product-card p {
    color: #666;
    font-size: 0.9rem;
    line-height: 1.6;
}

/* Imagem e Indicadores */
.image-sticky {
    position: sticky;
    top: 20px;
}

.main-image {
    position: relative;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    margin-bottom: 30px;
}

.main-image img {
    width: 100%;
    height: auto;
    display: block;
    transition: transform 0.3s ease;
}

.main-image:hover img {
    transform: scale(1.05);
}

.performance-indicators {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    margin-top: 30px;
}

.indicator {
    background: white;
    padding: 20px;
    border-radius: 15px;
    text-align: center;
    box-shadow: 0 10px 20px rgba(0,0,0,0.05);
}

.indicator-value {
    font-size: 1.8rem;
    font-weight: 700;
    color: #e4451d;
    margin-bottom: 5px;
}

.indicator-label {
    color: #666;
    font-size: 0.9rem;
}

/* CTA */
.cta-wrapper {
    margin-top: 40px;
    text-align: center;
}

.cta-button {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 15px 30px;
    background: #e4451d;
    color: white;
    text-decoration: none;
    border-radius: 30px;
    font-weight: 500;
    transition: all 0.3s ease;
}

.cta-button:hover {
    background: #00214e;
    transform: translateY(-2px);
}

/* Responsividade */
@media (max-width: 992px) {
    .content-grid {
        grid-template-columns: 1fr;
    }

    .text-column {
        padding-right: 0;
    }

    .image-sticky {
        position: relative;
        top: 0;
        margin-top: 40px;
    }

    .products-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .hero-content h1 {
        font-size: 2.5rem;
    }

    .hero-subtitle {
        font-size: 1.2rem;
    }

    .text-content {
        padding: 20px;
    }

    .products-grid {
        grid-template-columns: 1fr;
    }

    .performance-indicators {
        grid-template-columns: 1fr;
    }
}
</style>

<!-- Scripts para animações -->
<script>
    AOS.init({
        duration: 800,
        once: true
    });
</script>

<?php include 'footer.php'; ?>