<?php 
$pageTitle = 'Quem Somos - Sierro Engenharia';
include 'header.php'; 
?>


<!-- No seu header, substitua o link atual do Font Awesome por este -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">


<!-- Barra de título -->
<div class="page-header">
    <div class="header-overlay"></div>
    <div class="container">
        <div class="header-content">
            <span class="header-subtitle">Sierro Engenharia</span>
            <h1 class="header-title">Quem Somos</h1>
            <div class="header-divider"></div>
        </div>
    </div>
</div>

<!-- Seção Principal -->
<section class="main-content">
    <div class="container">
        <div class="content-wrapper">
            <h2 class="section-title">Conheça a Sierro</h2>
            
            <div class="about-text">
                <p class="lead">
                   A Sierro Engenharia traz experiência e tecnologia desde 1962, quando chegou ao Brasil por meio da Nestlé, com o propósito de oferecer projetos e soluções tecnológicas em equipamentos agroindustriais para o setor Sucroalcooleiro . Ao longo dos anos, a empresa expandiu seu alcance, beneficiando não apenas o setor de alimentos, mas também outros segmentos como o sucroalcooleiro, que passaram a contar com sua expertise em projetos e equipamentos de alta qualidade.
                </p>
            </div>

            <!-- Grid de Setores -->
            <div class="sectors-grid">
                <div class="sector-card">
                    <i class="fas fa-coffee"></i>
                    <h3>Plantas de Café Solúvel</h3>
                </div>
                <div class="sector-card">
                    <i class="fas fa-flask"></i>
                    <h3>Aromas</h3>
                </div>
                <div class="sector-card">
                    <i class="fas fa-apple-alt"></i>
                    <h3>Suco de Frutas</h3>
                </div>
                <div class="sector-card">
                    <i class="fas fa-wheat-awn"></i>
                    <h3>Beneficiamento de Grãos</h3>
                </div>
                <div class="sector-card">
                    <i class="fas fa-atom"></i>
                    <h3>Carboidratos em Geral</h3>
                </div>
                <div class="sector-card">
                    <i class="fas fa-industry"></i>
                    <h3>Plantas de Produção de Ração Animal</h3>
                </div>
                <div class="sector-card">
                    <i class="fas fa-flask-vial"></i>
                    <h3>Laboratórios de P&D</h3>
                </div>
                <div class="sector-card">
                    <i class="fas fa-industry"></i>
                    <h3>Plantas de Produção de Gelatina</h3>
                </div>
                <div class="sector-card">
                    <i class="fas fa-industry"></i>
                    <h3>Sucroalcooleiro</h3>
                </div>
            </div>

            <!-- Texto Sobre Consultoria -->
            <div class="consulting-text">
                <p>
                    A Sierro Engenharia não se limita a apenas comercializar equipamentos, os nossos profissionais 
                    atuam como consultores para entender a real necessidade do cliente e oferecer as tecnologias 
                    mais adequadas para que o cliente obtenha o melhor produto final aliado a produtividade e 
                    economia na operação.
                </p>
            </div>

            <!-- Especialidades -->
            <div class="specialties-section">
                <h3>Nossa especialidade se dedica a projetos de:</h3>
                <div class="specialties-grid">
                    <div class="specialty-item">
                        <i class="fas fa-spray-can"></i>
                        <span>Spray Dryers para secagem dos mais variados tipos de produtos</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-vial"></i>
                        <span>Extração</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-temperature-high"></i>
                        <span>Pasteurização</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-truck"></i>
                        <span>Transporte Mecânico e Pneumático</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-fire"></i>
                        <span>Torrefação</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-cubes"></i>
                        <span>Aglomeradores</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-wind"></i>
                        <span>Leito Fluidizado</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-flask-vial"></i>
                        <span>Colunas de Destilação</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-cube"></i>
                        <span>Tanques</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-filter"></i>
                        <span>Filtros</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-temperature-arrow-up"></i>
                        <span>Evaporadores</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-chart-line"></i>
                        <span>Business Plan para melhorias</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-industry"></i>
                        <span>Aumento da capacidade produtiva</span>
                    </div>
                    <div class="specialty-item">
                        <i class="fas fa-cogs"></i>
                        <span>Operação Assistida</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!--########################## missao e valores e principios -->

<!-- Seção MVV -->
<section class="mvv-section">
    <div class="container">
        <div class="mvv-grid">
            <!-- Card Missão -->
            <div class="mvv-card" data-aos="fade-up">
                <div class="mvv-icon">
                    <i class="fas fa-rocket"></i>
                </div>
                <h3>Missão</h3>
                <div class="mvv-divider"></div>
                <p>Prover tecnologia e eficiência associado a economia atendendo as necessidades dos nossos clientes.</p>
            </div>

            <!-- Card Visão -->
            <div class="mvv-card" data-aos="fade-up" data-aos-delay="100">
                <div class="mvv-icon">
                    <i class="fas fa-eye"></i>
                </div>
                <h3>Visão</h3>
                <div class="mvv-divider"></div>
                <p>Ser reconhecido pela excelência e qualidade dos projetos e serviços prestados.</p>
            </div>

            <!-- Card Valores -->
            <div class="mvv-card" data-aos="fade-up" data-aos-delay="200">
                <div class="mvv-icon">
                    <i class="fas fa-star"></i>
                </div>
                <h3>Valores</h3>
                <div class="mvv-divider"></div>
                <ul class="values-list">
                    <li>
                        <i class="fas fa-check-circle"></i>
                        Atrair para a organização pessoas que alinhem ao nosso propósito
                    </li>
                    <li>
                        <i class="fas fa-check-circle"></i>
                        Tomadas de decisão com foco na Missão e a Visão
                    </li>
                    <li>
                        <i class="fas fa-check-circle"></i>
                        Compromisso com a ética e honestidade junto aos nossos clientes, fornecedores e toda sociedade
                    </li>
                </ul>
            </div>
        </div>
    </div>
</section>

<!--########################### Seção História -->
<!-- Seção História -->
<section class="history-section">
    <div class="container">
        <h2 class="section-title">A Nossa História</h2>
        <div class="history-container">
            <!-- Coluna de Texto -->
            <div class="history-text">
                <p class="history-paragraph">
                    No início da década de 60, o então Engenheiro Gerard Sierro se mudou com a esposa e dois filhos pequenos 
                    da cidade de Martigny na Suíça para a cidade de Araras no interior de São Paulo com a missão de coordenar 
                    e implantar a linha Baby Food da Nestle no Brasil.
                </p>
                
                <p class="history-paragraph">
                    Após o êxito desse projeto e o sentimento de missão cumprida, o Sr. Sierro identificou no mercado 
                    brasileiro uma certa carência de profissionais que tivessem os conhecimentos necessários para atender 
                    a demanda de empresas que necessitassem do aperfeiçoamento tecnológico dentro das suas fabricas e 
                    projetos para a indústria de café solúvel com um olhar dedicado à sua operação.
                </p>

                <p class="history-paragraph">
                    Diante disso, identificou um novo nicho de negócios que se iniciou com o projeto de Spray Dryers 
                    para os mais variados tipos de produtos e empresas e projetos industriais no setor do agronegócio.
                </p>

                <p class="history-paragraph">
                    A excelência de projetos e equipamentos reconhecido pelos clientes, gerou uma notoriedade alcançando 
                    o conhecimento de clientes internacionais proporcionando novas oportunidades de negócios com projetos 
                    na Índia, Singapura, China, México, Paraguai, Equador, Indonésia, Itália, Bélgica e Portugal.
                </p>
            </div>

            <!-- Coluna do Slider -->
            <div class="history-slider">
                <div class="swiper historySwiper">
                    <div class="swiper-wrapper">
                        <!-- Slide 1 -->
                        <div class="swiper-slide">
                            <div class="slide-content">
                                <img src="images/historia/sirro_conde.jpeg" alt="Sr. Sierro e Conde Matarazzo">
                                <div class="slide-caption">
                                    <p>Sr. Sierro a esquerda e o Conde Matarazzo no centro</p>
                                </div>
                            </div>
                        </div>
                        <!-- Slide 2 -->
                        <div class="swiper-slide">
                            <div class="slide-content">
                                <img src="images/historia/sirro_conde.jpeg" alt="Sr. Sierro a direita ">
                                <div class="slide-caption">
                                    <p>Sr. Sierro a direita</p>
                                </div>
                            </div>
                        </div>
                        <!-- Slide 3 - CORRIGIDO -->
<div class="swiper-slide">
    <div class="slide-content">
        <img src="images/historia/sierro_almoco.jpeg" alt="Histórica da Sierro 3">
        <div class="slide-caption">
            <p>Sr.Sierro almocando com os Colaboradores durante a execucao da Fabrica de Cafe Soluvel na China</p>
        </div>
    </div>
</div>
                        <!-- Slide 4 -->
                        <div class="swiper-slide">
                            <div class="slide-content">
                                <img src="images/historia/sirro_china.jpeg" alt="Sierro na China">
                                <div class="slide-caption">
                                    <p>Sierro na China</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Adicione a navegação -->
                    <div class="swiper-pagination"></div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </div>
    </div>
</section>


<style>
/* Barra de título */
.page-title-bar {
    background: #e4451d;
    color: white;
    padding: 20px 0;
    border-top: 1px solid rgba(255,255,255,0.1);
    border-bottom: 1px solid rgba(255,255,255,0.1);
}

.page-title-bar h1 {
    margin: 0;
    font-size: 24px;
    font-weight: 500;
}

/* Conteúdo Principal */
.main-content {
    padding: 60px 0;
    background: #fff;
}

.content-wrapper {
    max-width: 1200px;
    margin: 0 auto;
}

.section-title {
    color: #e4451d;
    font-size: 32px;
    margin-bottom: 30px;
    text-align: center;
}

.about-text {
    margin-bottom: 50px;
}

.lead {
    font-size: 18px;
    line-height: 1.8;
    color: #333;
}

/* Grid de Setores */
.sectors-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 25px;
    margin: 40px 0;
}

.sector-card {
    background: #f8f9fa;
    padding: 25px;
    border-radius: 10px;
    text-align: center;
    transition: all 0.3s ease;
}

.sector-card:hover {
     transform: translateY(-5px);
    box-shadow: 0 5px 15px rgba(228, 69, 29, 0.2); /* Sombra com a nova cor */
}

.sector-card i {
    font-size: 32px;
    color: #e4451d; 
    margin-bottom: 15px;
}

.sector-card h3 {
    font-size: 18px;
    color: #333;
}

/* Texto de Consultoria */
.consulting-text {
    margin: 50px 0;
    padding: 30px;
    background: #f8f9fa;
    border-radius: 10px;
    font-size: 18px;
    line-height: 1.8;
}

/* Especialidades */
.specialties-section {
    margin-top: 50px;
}

.specialties-section h3 {
    color: #e4451d;
    text-align: center;
    margin-bottom: 30px;
}

.specialties-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
}

.specialty-item {
    display: flex;
    align-items: center;
    padding: 15px;
    background: #f8f9fa;
    border-radius: 8px;
    transition: all 0.3s ease;
}

.specialty-item:hover {
    transform: translateX(5px);
    background: #e4451d;;
    color: white;
}

.specialty-item:hover i {
    color: white;
}

.specialty-item i {
    font-size: 24px;
    color: #e4451d;
    margin-right: 15px;
    transition: all 0.3s ease;
}

.specialty-item span {
    font-size: 16px;
}

/* Responsivo */
@media (max-width: 768px) {
    .sectors-grid {
        grid-template-columns: 1fr;
    }

    .specialties-grid {
        grid-template-columns: 1fr;
    }

    .consulting-text {
        padding: 20px;
    }
}

/* Seção MVV */
.mvv-section {
    padding: 80px 0;
    background: #f8f9fa;
    position: relative;
    overflow: hidden;
}

.mvv-section::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 5px;
    background: linear-gradient(90deg, transparent, #e4451d, transparent);
}

.mvv-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 30px;
    max-width: 1200px;
    margin: 0 auto;
}

.mvv-card {
    background: white;
    padding: 40px 30px;
    border-radius: 15px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.mvv-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 40px rgba(228, 69, 29, 0.15);
}

.mvv-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 5px;
    background: #e4451d;
    transform: scaleX(0);
    transition: transform 0.3s ease;
    transform-origin: left;
}

.mvv-card:hover::before {
    transform: scaleX(1);
}

.mvv-icon {
    width: 70px;
    height: 70px;
    background: #fff2f0;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 20px;
}

.mvv-icon i {
    font-size: 30px;
    color: #e4451d;
}

.mvv-card h3 {
    font-size: 24px;
    color: #333;
    margin-bottom: 15px;
}

.mvv-divider {
    width: 50px;
    height: 3px;
    background: #e4451d;
    margin: 15px 0;
}

.mvv-card p {
    color: #666;
    line-height: 1.6;
    margin: 0;
}

.values-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.values-list li {
    display: flex;
    align-items: flex-start;
    margin-bottom: 15px;
    color: #666;
    line-height: 1.5;
}

.values-list li i {
    color: #e4451d;
    margin-right: 10px;
    margin-top: 4px;
    font-size: 14px;
}

/* Responsivo */
@media (max-width: 768px) {
    .mvv-section {
        padding: 60px 0;
    }

    .mvv-grid {
        grid-template-columns: 1fr;
        padding: 0 20px;
    }

    .mvv-card {
        padding: 30px 20px;
    }
}

/* Animação de entrada */
[data-aos] {
    opacity: 0;
    transform: translateY(30px);
    transition: all 0.6s ease;
}

[data-aos].aos-animate {
    opacity: 1;
    transform: translateY(0);
}

/* Seção História */
.history-section {
    padding: 80px 0;
    background: #fff;
    position: relative;
}

.history-container {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 50px;
    align-items: center;
    margin-top: 40px;
}

/* Coluna de Texto */
.history-text {
    padding-right: 30px;
}

.history-paragraph {
    font-size: 16px;
    line-height: 1.8;
    color: #333;
    margin-bottom: 20px;
    text-align: justify; /* Adiciona justificação ao texto */
    text-justify: inter-word; /* Melhora a distribuição das palavras */
}
.history-paragraph:last-child {
    margin-bottom: 0;
}

/* Coluna do Slider */
.history-slider {
    position: relative;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

/* Swiper Slider Customização */
.swiper {
    width: 100%;
    height: 500px;
}

.slide-content {
    position: relative;
    width: 100%;
    height: 100%;
}

.slide-content img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.slide-caption {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: rgba(0,0,0,0.7);
    color: white;
    padding: 15px;
    text-align: center;
}

.slide-caption p {
    margin: 0;
    font-size: 16px;
}

/* Navegação do Slider */
.swiper-button-next,
.swiper-button-prev {
    color: #e4451d;
}

.swiper-pagination-bullet-active {
    background: #e4451d;
}

/* Efeito de Hover no Slider */
.history-slider:hover .swiper-button-next,
.history-slider:hover .swiper-button-prev {
    opacity: 1;
}

/* Responsivo */
@media (max-width: 992px) {
    .history-container {
        grid-template-columns: 1fr;
    }

    .history-text {
        padding-right: 0;
    }

    .swiper {
        height: 400px;
    }
}

@media (max-width: 768px) {
    .history-section {
        padding: 60px 0;
    }

    .swiper {
        height: 300px;
    }
}





/* Decoração de fundo */
.page-header::before,
.page-header::after {
    content: '';
    position: absolute;
    width: 300px;
    height: 300px;
    background: radial-gradient(circle, rgba(228, 69, 29, 0.03) 0%, transparent 70%);
    border-radius: 50%;
}

.page-header::before {
    top: -150px;
    left: -150px;
}

.page-header::after {
    bottom: -150px;
    right: -150px;
}

/* Responsividade */
@media (max-width: 768px) {
    .page-header {
        height: 250px;
    }

    .header-title {
        font-size: 36px;
    }

    .header-subtitle {
        font-size: 16px;
    }
}

@media (max-width: 480px) {
    .page-header {
        height: 200px;
    }

    .header-title {
        font-size: 28px;
    }

    .header-subtitle {
        font-size: 14px;
    }
}

/* Efeito de profundidade */
.page-header::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 1px;
    background: linear-gradient(to right, transparent, rgba(228, 69, 29, 0.1), transparent);
}

/* Sombra suave na parte inferior */
.page-header::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    height: 20px;
    background: linear-gradient(to bottom, transparent, rgba(0,0,0,0.02));
}

/* Novo estilo para o cabeçalho da página */
.page-header {
    position: relative;
    height: 300px;
    background: linear-gradient(45deg, #f8f9fa 0%, #ffffff 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
    margin-bottom: 40px;
}

.header-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(45deg, rgba(228, 69, 29, 0.05) 0%, rgba(228, 69, 29, 0.1) 100%);
}

.header-content {
    position: relative;
    text-align: center;
    padding: 0 20px;
    z-index: 1;
}

.header-subtitle {
    display: block;
    font-size: 18px;
    color: #e4451d;
    margin-bottom: 15px;
    font-weight: 500;
    letter-spacing: 2px;
    text-transform: uppercase;
    opacity: 0;
    animation: fadeInUp 0.6s ease forwards;
}

.header-title {
    font-size: 48px;
    color: #333;
    margin: 0;
    font-weight: 300;
    letter-spacing: -1px;
    opacity: 0;
    animation: fadeInUp 0.6s ease forwards 0.2s;
}

.header-divider {
    width: 80px;
    height: 3px;
    background: linear-gradient(to right, transparent, #e4451d, transparent);
    margin: 25px auto 0;
    opacity: 0;
    animation: expandWidth 0.6s ease forwards 0.4s;
}

/* Animações do cabeçalho */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes expandWidth {
    from {
        opacity: 0;
        width: 0;
    }
    to {
        opacity: 1;
        width: 80px;
    }
}
</style>



<!-- Adicione o AOS (Animate on Scroll) no head do seu documento -->
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script>
    // Inicializa o AOS
    AOS.init({
        duration: 800,
        once: true
    });
</script>
<!-- Inicialização do Swiper -->
<script>
   document.addEventListener('DOMContentLoaded', function() {
    var swiper = new Swiper(".historySwiper", {
        slidesPerView: 1,
        spaceBetween: 30,
        loop: true,
        autoplay: {
            delay: 5000,
            disableOnInteraction: false,
        },
        pagination: {
            el: ".swiper-pagination",
            clickable: true,
        },
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        effect: "fade",
        fadeEffect: {
            crossFade: true
        }
    });
});
</script>

<?php include 'footer.php'; ?>