<?php 
$pageTitle = 'Spray Dryer - Sierro Engenharia';
include 'header.php'; 
?>

<!-- Hero Section Moderna -->
<section class="hero-banner">
    <div class="container">
        <div class="hero-content">
            <h1 class="animate-up">Spray Dryer </h1>
            <div class="hero-divider animate-up"></div>
            <p class="hero-subtitle animate-up">Soluções avançadas </p>
        </div>
    </div>
</section>

<!-- Conteúdo Principal -->
<main class="main-content">
    <div class="container">
        <!-- Grid Principal -->
        <div class="content-grid">
            <!-- Coluna de Texto -->
            <div class="text-column" data-aos="fade-right">
                <div class="text-content">
                    <div class="text-block">
                        <div class="section-tag">Tecnologia de Ponta</div>
                        <p>
                            A Sierro Engenharia desenvolve projetos de spray dryer sob medida para as necessidades específicas de cada cliente.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Como Funciona</div>
                        <p>
                            Spray dryer é uma tecnologia utilizada para realizar a secagem de vários produtos utilizando o processo de atomização para a produção de pó a partir de um estado líquido contendo sólidos.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Vantagens</div>
                        <p>
                            Algumas das vantagens da secagem por spray dryer, inclui sua capacidade de ser totalmente automatizado e contínuo, com tempos de residência curtos e adequação para alimentos sensíveis.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Aplicações</div>
                        <p>
                            Nossos equipamentos e tecnologia são adequados para uma variedade enorme de matérias-primas desde que sejam bombeáveis, ou seja, produtos que contêm sólidos como: leite, extrato de café, extrato de chá, extrato de chicória, leite de soja, chocolate, polpas de frutas, amidos em geral, essências etc.
                        </p>
                    </div>

                    <!-- Botão de Orçamento -->
                    <div class="cta-wrapper">
                        <a href="contato.php" class="cta-button">
                            <span>Solicitar Orçamento</span>
                            <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Coluna da Imagem -->
            <div class="image-column" data-aos="fade-left">
                <div class="image-sticky">
                    <div class="main-image">
                        <img src="images/centrifugal-spray-dryer.webp" alt="Spray Dryer Industrial Sierro">
                        <div class="image-overlay">
                            <div class="specs-list">
                                <div class="spec-item">
                                    <i class="fas fa-cog"></i>
                                    <span>Automação Total</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-tachometer-alt"></i>
                                    <span>Alta Performance</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-industry"></i>
                                    <span>Múltiplas Aplicações</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
/* Hero Banner */
.hero-banner {
    background: linear-gradient(45deg, #00214e, #003175);
    padding: 100px 0;
    color: white;
    position: relative;
    overflow: hidden;
}

.hero-banner::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 50%;
    height: 100%;
    background: url('assets/images/pattern.png') repeat;
    opacity: 0.1;
}

.hero-content {
    text-align: center;
    position: relative;
    z-index: 2;
}

.hero-content h1 {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 20px;
}

.hero-divider {
    width: 100px;
    height: 4px;
    background: #e4451d;
    margin: 0 auto 20px;
}

.hero-subtitle {
    font-size: 1.5rem;
    opacity: 0.9;
}

/* Layout Principal */
.main-content {
    padding: 80px 0;
    background: #f8f9fa;
}

.container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 20px;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 60px;
    align-items: start;
}

/* Coluna de Texto */
.text-column {
    padding-right: 40px;
}

.text-content {
    background: white;
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.text-block {
    margin-bottom: 40px;
}

.section-tag {
    display: inline-block;
    padding: 8px 16px;
    background: #fff2f0;
    color: #e4451d;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 500;
    margin-bottom: 15px;
}

.text-block p {
   font-size: 1.2rem;
    line-height: 1.8;
    color: #444;
    margin: 0;
    text-align: justify; /* Adiciona justificação ao texto */
    text-justify: inter-word; /* Melhora a distribuição das palavras */

}

/* Coluna da Imagem */
.image-sticky {
    position: sticky;
    top: 20px;
}

.main-image {
    position: relative;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}

.main-image img {
    width: 100%;
    height: auto;
    display: block;
    transition: transform 0.3s ease;
}

.main-image:hover img {
    transform: scale(1.05);
}

.image-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.8), transparent);
    padding: 30px;
}

.specs-list {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
}

.spec-item {
    color: white;
    text-align: center;
}

.spec-item i {
    font-size: 24px;
    margin-bottom: 10px;
    color: #e4451d;
}

.spec-item span {
    display: block;
    font-size: 0.9rem;
}

/* Botão CTA */
.cta-wrapper {
    margin-top: 40px;
    text-align: center;
}

.cta-button {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 15px 30px;
    background: #e4451d;
    color: white;
    text-decoration: none;
    border-radius: 30px;
    font-weight: 500;
    transition: all 0.3s ease;
}

.cta-button:hover {
    background: #00214e;
    transform: translateY(-2px);
}

/* Animações */
.animate-up {
    opacity: 0;
    transform: translateY(30px);
    animation: fadeUp 0.6s ease forwards;
}

@keyframes fadeUp {
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Responsividade */
@media (max-width: 992px) {
    .content-grid {
        grid-template-columns: 1fr;
    }

    .text-column {
        padding-right: 0;
    }

    .image-sticky {
        position: relative;
        top: 0;
        margin-top: 40px;
    }
}

@media (max-width: 768px) {
    .hero-content h1 {
        font-size: 2.5rem;
    }

    .hero-subtitle {
        font-size: 1.2rem;
    }

    .text-content {
        padding: 20px;
    }

    .specs-list {
        grid-template-columns: 1fr;
        gap: 15px;
    }
}
</style>

<!-- Scripts para animações -->
<script>
    AOS.init({
        duration: 800,
        once: true
    });
</script>

<?php include 'footer.php'; ?>