<?php 
$pageTitle = 'Conversão de Spray Dryer - Sierro Engenharia';
include 'header.php'; 
?>

<!-- Hero Section -->
<section class="hero-banner">
    <div class="container">
        <div class="hero-content">
            <h1 class="animate-up">Conversão de Spray Dryer</h1>
            <div class="hero-divider animate-up"></div>
            <p class="hero-subtitle animate-up">De disco para bico atomizador</p>
        </div>
    </div>
</section>

<!-- Conteúdo Principal -->
<main class="main-content">
    <div class="container">
        <!-- Grid Principal -->
        <div class="content-grid">
            <!-- Coluna de Texto -->
            <div class="text-column" data-aos="fade-right">
                <div class="text-content">
                    <div class="text-block">
                        <div class="section-tag">Retrofit Especializado</div>
                        <p>
                            A Sierro Engenharia com sua experiência de atuação em Retrofit, realiza conversão de spray dryer de disco, para a tecnologia de bico atomizador.
                        </p>
                    </div>

                    <div class="benefits-section">
                        <div class="section-tag">Benefícios do Upgrade</div>
                        <ul class="benefits-list">
                            <li class="benefit-item">
                                <i class="fas fa-chart-line"></i>
                                <span>Aumento da eficiência de secagem e maior produtividade</span>
                            </li>
                            <li class="benefit-item">
                                <i class="fas fa-sliders-h"></i>
                                <span>Ajuste de densidade mais amplo na secagem do produto</span>
                            </li>
                            <li class="benefit-item">
                                <i class="fas fa-shield-alt"></i>
                                <span>Robustez e Alta Confiabilidade</span>
                            </li>
                            <li class="benefit-item">
                                <i class="fas fa-tools"></i>
                                <span>Redução da frequência de manutenções preventivas no equipamento</span>
                            </li>
                            <li class="benefit-item">
                                <i class="fas fa-cogs"></i>
                                <span>Redução do Spare Parts (Peças de Reposição) para manutenção</span>
                            </li>
                            <li class="benefit-item">
                                <i class="fas fa-industry"></i>
                                <span>Durante as manutenções, o equipamento pode funcionar parcialmente não interrompendo completamente a produção</span>
                            </li>
                        </ul>
                    </div>

                    <!-- Botão de Orçamento -->
                    <div class="cta-wrapper">
                        <a href="contato.php" class="cta-button">
                            <span>Solicitar Orçamento</span>
                            <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Coluna da Imagem -->
            <div class="image-column" data-aos="fade-left">
                <div class="image-sticky">
                    <div class="main-image">
                        <img src="images/conversao_spray.jpeg" alt="Conversão de Spray Dryer Sierro">
                        <div class="image-overlay">
                            <div class="specs-list">
                                <div class="spec-item">
                                    <i class="fas fa-sync-alt"></i>
                                    <span>Retrofit Completo</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-tachometer-alt"></i>
                                    <span>Alta Performance</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-check-circle"></i>
                                    <span>Tecnologia Avançada</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
/* Hero Banner */
.hero-banner {
    background: linear-gradient(45deg, #00214e, #003175);
    padding: 100px 0;
    color: white;
    position: relative;
    overflow: hidden;
}

.hero-banner::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 50%;
    height: 100%;
    background: url('assets/images/pattern.png') repeat;
    opacity: 0.1;
}

.hero-content {
    text-align: center;
    position: relative;
    z-index: 2;
}

.hero-content h1 {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 20px;
}

.hero-divider {
    width: 100px;
    height: 4px;
    background: #e4451d;
    margin: 0 auto 20px;
}

.hero-subtitle {
    font-size: 1.5rem;
    opacity: 0.9;
}

/* Layout Principal */
.main-content {
    padding: 80px 0;
    background: #f8f9fa;
}

.container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 20px;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 60px;
    align-items: start;
}

/* Texto e Benefícios */
.text-column {
    padding-right: 40px;
}

.text-content {
    background: white;
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.text-block {
    margin-bottom: 40px;
}

.text-block p {
    font-size: 1.2rem;
    line-height: 1.8;
    color: #444;
    text-align: justify;
    text-justify: inter-word;
    margin: 0;
}

.section-tag {
    display: inline-block;
    padding: 8px 16px;
    background: #fff2f0;
    color: #e4451d;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 500;
    margin-bottom: 15px;
}

/* Lista de Benefícios */
.benefits-list {
    list-style: none;
    padding: 0;
    margin: 20px 0 0;
}

.benefit-item {
    display: flex;
    align-items: flex-start;
    gap: 15px;
    padding: 15px;
    margin-bottom: 15px;
    background: #f8f9fa;
    border-radius: 10px;
    transition: all 0.3s ease;
}

.benefit-item:hover {
    background: #fff2f0;
    transform: translateX(10px);
}

.benefit-item i {
    color: #e4451d;
    font-size: 1.2rem;
    padding-top: 3px;
}

.benefit-item span {
    font-size: 1.1rem;
    color: #444;
    text-align: justify;
    text-justify: inter-word;
}

/* Imagem */
.image-sticky {
    position: sticky;
    top: 20px;
}

.main-image {
    position: relative;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}

.main-image img {
    width: 100%;
    height: auto;
    display: block;
    transition: transform 0.3s ease;
}

.main-image:hover img {
    transform: scale(1.05);
}

.image-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.8), transparent);
    padding: 30px;
}

/* CTA */
.cta-wrapper {
    margin-top: 40px;
    text-align: center;
}

.cta-button {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 15px 30px;
    background: #e4451d;
    color: white;
    text-decoration: none;
    border-radius: 30px;
    font-weight: 500;
    transition: all 0.3s ease;
}

.cta-button:hover {
    background: #00214e;
    transform: translateY(-2px);
}

/* Responsividade */
@media (max-width: 992px) {
    .content-grid {
        grid-template-columns: 1fr;
    }

    .text-column {
        padding-right: 0;
    }

    .image-sticky {
        position: relative;
        top: 0;
        margin-top: 40px;
    }
}

@media (max-width: 768px) {
    .hero-content h1 {
        font-size: 2.5rem;
    }

    .hero-subtitle {
        font-size: 1.2rem;
    }

    .text-content {
        padding: 20px;
    }

    .benefit-item {
        padding: 10px;
    }

    .benefit-item span {
        font-size: 1rem;
    }
}
</style>

<!-- Scripts para animações -->
<script>
    AOS.init({
        duration: 800,
        once: true
    });
</script>

<?php include 'footer.php'; ?>