<?php include 'header.php'; ?>

<section class="gallery-master">
    <!-- Banner Hero da Galeria -->
    <div class="gallery-hero">
        <div class="container">
            <div class="hero-content" data-aos="fade-up">
                <h1>Galeria Sierro Engenharia</h1>
                <div class="hero-divider"></div>
            </div>
        </div>
    </div>

    <!-- Seção de Vídeos -->
    <div class="video-section">
        <div class="container">
            <div class="section-title" data-aos="fade-up">
                <h2>Vídeos</h2>
                <div class="title-separator">
                    <span class="separator-line"></span>
                    <span class="separator-icon"><i class="fas fa-play-circle"></i></span>
                    <span class="separator-line"></span>
                </div>
            </div>

            <div class="videos-row" data-aos="fade-up">
                <!-- Vídeo 1 -->
                <div class="video-card">
                    <div class="video-wrapper">
                        <iframe width="560" height="315" src="https://www.youtube.com/embed/nPxm33A2G2g?si=7BAYYs_XKBtoErNc" 
                                frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                                allowfullscreen></iframe>
                    </div>
                </div>

                <!-- Vídeo 2 -->
                <div class="video-card">
                    <div class="video-wrapper">
                        <iframe width="560" height="315" src="https://www.youtube.com/embed/5oH3DAGUF-8?si=U5WpukDKrHJdA6hV" 
                                frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                                allowfullscreen></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Galeria de Fotos -->
    <div class="photo-gallery">
        <div class="container">
            <div class="section-title" data-aos="fade-up">
                <h2>Galeria de Fotos</h2>
                <div class="title-separator">
                    <span class="separator-line"></span>
                    <span class="separator-icon"><i class="fas fa-camera"></i></span>
                    <span class="separator-line"></span>
                </div>
            </div>

            <div class="filter-buttons" data-aos="fade-up">
                <button class="filter-btn active" data-filter="all">Todos</button>
                <button class="filter-btn" data-filter="spray">Spray Dryer</button>
                <button class="filter-btn" data-filter="transport">Transporte</button>
                <button class="filter-btn" data-filter="industry">Industrial</button>
            </div>

            <div class="gallery-grid" data-aos="fade-up">
                <!-- Item 1 -->
                <div class="gallery-item spray">
                    <img src="images/galeria/1.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/1.jpeg', 0)">
                </div>

                <!-- Item 2 -->
                <div class="gallery-item transport">
                    <img src="images/galeria/2.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/2.jpeg', 1)">
                </div>

                <!-- Item 3 -->
                <div class="gallery-item industry">
                    <img src="images/galeria/3.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/3.jpeg', 2)">
                </div>

                <!-- Item 4 -->
                <div class="gallery-item spray">
                    <img src="images/galeria/4.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/4.jpeg', 3)">
                </div>

                <!-- Item 5 -->
                <div class="gallery-item transport">
                    <img src="images/galeria/5.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/5.jpeg', 4)">
                </div>

                <!-- Item 6 -->
                <div class="gallery-item industry">
                    <img src="images/galeria/6.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/6.jpeg', 5)">
                </div>
                <!-- Item 7 -->
<div class="gallery-item spray">
    <img src="images/galeria/7.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/7.jpeg', 6)">
</div>

<!-- Item 8 -->
<div class="gallery-item transport">
    <img src="images/galeria/8.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/8.jpeg', 7)">
</div>

<!-- Item 9 -->
<div class="gallery-item industry">
    <img src="images/galeria/9.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/9.jpeg', 8)">
</div>

<!-- Item 10 -->
<div class="gallery-item spray">
    <img src="images/galeria/10.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/10.jpeg', 9)">
</div>

<!-- Item 11 -->
<div class="gallery-item transport">
    <img src="images/galeria/11.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/11.jpeg', 10)">
</div>

<!-- Item 12 -->
<div class="gallery-item industry">
    <img src="images/galeria/12.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/12.jpeg', 11)">
</div>

<!-- Item 13 -->
<div class="gallery-item spray">
    <img src="images/galeria/13.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/13.jpeg', 12)">
</div>

<!-- Item 14 -->
<div class="gallery-item transport">
    <img src="images/galeria/14.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/14.jpeg', 13)">
</div>

<!-- Item 15 -->
<div class="gallery-item industry">
    <img src="images/galeria/15.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/15.jpeg', 14)">
</div>

<!-- Item 16 -->
<div class="gallery-item spray">
    <img src="images/galeria/16.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/16.jpeg', 15)">
</div>

<!-- Item 17 -->
<div class="gallery-item transport">
    <img src="images/galeria/17.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/17.jpeg', 16)">
</div>

<!-- Item 18 -->
<div class="gallery-item industry">
    <img src="images/galeria/18.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/18.jpeg', 17)">
</div>

<!-- Item 19 -->
<div class="gallery-item spray">
    <img src="images/galeria/19.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/19.jpeg', 18)">
</div>

<!-- Item 20 -->
<div class="gallery-item transport">
    <img src="images/galeria/20.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/20.jpeg', 19)">
</div>

<!-- Item 21 -->
<div class="gallery-item industry">
    <img src="images/galeria/21.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/21.jpeg', 20)">
</div>

<!-- Item 22 -->
<div class="gallery-item spray">
    <img src="images/galeria/22.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/22.jpeg', 21)">
</div>

<!-- Item 23 -->
<div class="gallery-item transport">
    <img src="images/galeria/23.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/23.jpeg', 22)">
</div>

<!-- Item 24 -->
<div class="gallery-item industry">
    <img src="images/galeria/24.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/24.jpeg', 23)">
</div>

<!-- Item 25 -->
<div class="gallery-item spray">
    <img src="images/galeria/25.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/25.jpeg', 24)">
</div>

<!-- Item 26 -->
<div class="gallery-item transport">
    <img src="images/galeria/26.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/26.jpeg', 25)">
</div>

<!-- Item 27 -->
<div class="gallery-item industry">
    <img src="images/galeria/27.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/27.jpeg', 26)">
</div>

<!-- Item 28 -->
<div class="gallery-item spray">
    <img src="images/galeria/28.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/28.jpeg', 27)">
</div>

<!-- Item 29 -->
<div class="gallery-item transport">
    <img src="images/galeria/29.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/29.jpeg', 28)">
</div>

<!-- Item 30 -->
<div class="gallery-item industry">
    <img src="images/galeria/30.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/30.jpeg', 29)">
</div>

<!-- Item 31 -->
<div class="gallery-item spray">
    <img src="images/galeria/31.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/31.jpeg', 30)">
</div>

<!-- Item 32 -->
<div class="gallery-item transport">
    <img src="images/galeria/32.jpeg" alt="Projeto Sierro" onclick="openModal('images/galeria/32.jpeg', 31)">
</div>
            </div>
        </div>
    </div>

    <!-- Modal para o slider de imagens -->
    <div id="galleryModal" class="gallery-modal">
        <span class="close-modal" onclick="closeModal()">&times;</span>
        
        <div class="modal-content">
            <img id="modalImage" src="" alt="Projeto Sierro" class="modal-img">
        </div>
        
        <!-- Controles do slider -->
        <a class="prev" onclick="plusSlides(-1)">&#10094;</a>
        <a class="next" onclick="plusSlides(1)">&#10095;</a>
    </div>
</section>

<style>
/* Estilos Gerais */
.gallery-master {
    background: #f8f9fa;
    padding-bottom: 80px;
    font-family: 'Poppins', sans-serif;
}

.container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 20px;
}

/* Banner Hero */
.gallery-hero {
    background: linear-gradient(rgba(0, 33, 78, 0.8), rgba(0, 33, 78, 0.9)), url('images/hero-bg.jpg') center/cover no-repeat;
    padding: 100px 0;
    color: white;
    text-align: center;
}

.hero-content h1 {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 20px;
}

.hero-divider {
    width: 100px;
    height: 4px;
    background: #e4451d;
    margin: 0 auto;
}

/* Títulos e Separadores */
.section-title {
    text-align: center;
    margin-bottom: 40px;
    padding-top: 80px;
}

.section-title h2 {
    color: #00214e;
    font-size: 2.5rem;
    margin-bottom: 20px;
    font-weight: 600;
}

.title-separator {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 15px;
}

.separator-line {
    width: 50px;
    height: 2px;
    background: #e4451d;
}

.separator-icon {
    color: #e4451d;
    font-size: 1.5rem;
}

/* Seção de Vídeos */
.video-section {
    background: white;
    padding-bottom: 40px;
}

.videos-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 30px;
}

.video-card {
    background: #f8f9fa;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}

.video-card:hover {
    transform: translateY(-10px);
}

.video-wrapper {
    position: relative;
    padding-bottom: 56.25%; /* 16:9 Aspect Ratio */
    height: 0;
    overflow: hidden;
}

.video-wrapper iframe {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    border: none;
}

/* Galeria de Fotos */
.photo-gallery {
    background: #f8f9fa;
}

.filter-buttons {
    display: flex;
    justify-content: center;
    margin-bottom: 30px;
    flex-wrap: wrap;
    gap: 15px;
}

.filter-btn {
    padding: 12px 25px;
    border: none;
    background: white;
    color: #00214e;
    border-radius: 30px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
}

.filter-btn.active,
.filter-btn:hover {
    background: #00214e;
    color: white;
    transform: translateY(-3px);
}

.gallery-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
}

.gallery-item {
    position: relative;
    overflow: hidden;
    border-radius: 10px;
    box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    transform: translateY(0);
    transition: all 0.3s ease;
    cursor: pointer;
}

.gallery-item:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 30px rgba(0,0,0,0.15);
}

.gallery-item img {
    width: 100%;
    height: 250px;
    object-fit: cover;
    display: block;
    transition: all 0.5s ease;
}

.gallery-item:hover img {
    transform: scale(1.1);
}

/* Modal de Galeria */
.gallery-modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: hidden;
    background-color: rgba(0,0,0,0.9);
}

.modal-content {
    position: relative;
    margin: auto;
    width: 90%;
    max-width: 1200px;
    height: 90vh;
    display: flex;
    align-items: center;
    justify-content: center;
}

.modal-img {
    max-height: 85vh;
    max-width: 100%;
    object-fit: contain;
}

.close-modal {
    position: absolute;
    top: 20px;
    right: 35px;
    color: #f1f1f1;
    font-size: 40px;
    font-weight: bold;
    cursor: pointer;
    z-index: 999;
    transition: color 0.3s ease;
}

.close-modal:hover,
.close-modal:focus {
    color: #e4451d;
    text-decoration: none;
}

/* Botões Next & Previous */
.prev,
.next {
    cursor: pointer;
    position: absolute;
    top: 50%;
    width: auto;
    padding: 16px;
    margin-top: -50px;
    color: white;
    font-weight: bold;
    font-size: 30px;
    transition: 0.6s ease;
    border-radius: 0 3px 3px 0;
    user-select: none;
    -webkit-user-select: none;
    background-color: rgba(0, 0, 0, 0.3);
}

.next {
    right: 0;
    border-radius: 3px 0 0 3px;
}

.prev {
    left: 0;
}

.prev:hover,
.next:hover {
    background-color: #e4451d;
}

/* Responsividade */
@media (max-width: 992px) {
    .gallery-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .hero-content h1 {
        font-size: 3rem;
    }
    
    .section-title h2 {
        font-size: 2.2rem;
    }
}

@media (max-width: 768px) {
    .videos-row {
        grid-template-columns: 1fr;
    }
    
    .gallery-hero {
        padding: 80px 0;
    }
    
    .hero-content h1 {
        font-size: 2.5rem;
    }
    
    .section-title {
        padding-top: 60px;
    }
    
    .section-title h2 {
        font-size: 1.8rem;
    }
    
    .filter-btn {
        padding: 10px 20px;
        font-size: 0.9rem;
    }
    
    .prev,
    .next {
        padding: 8px;
        font-size: 20px;
    }
}

@media (max-width: 576px) {
    .gallery-grid {
        grid-template-columns: 1fr;
    }
    
    .filter-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .filter-btn {
        width: 100%;
        max-width: 200px;
    }
}
</style>

<script>
// Array para armazenar todas as imagens da galeria
let galleryImages = [
    'images/galeria/1.jpeg',
    'images/galeria/2.jpeg',
    'images/galeria/3.jpeg',
    'images/galeria/4.jpeg',
    'images/galeria/5.jpeg',
    'images/galeria/6.jpeg',
    'images/galeria/7.jpeg',
    'images/galeria/8.jpeg',
    'images/galeria/9.jpeg',
    'images/galeria/10.jpeg',
    'images/galeria/11.jpeg',
    'images/galeria/12.jpeg',
    'images/galeria/13.jpeg',
    'images/galeria/14.jpeg',
    'images/galeria/15.jpeg',
    'images/galeria/16.jpeg',
    'images/galeria/17.jpeg',
    'images/galeria/18.jpeg',
    'images/galeria/19.jpeg',
    'images/galeria/20.jpeg',
    'images/galeria/21.jpeg',
    'images/galeria/22.jpeg',
    'images/galeria/23.jpeg',
    'images/galeria/24.jpeg',
    'images/galeria/25.jpeg',
    'images/galeria/26.jpeg',
    'images/galeria/27.jpeg',
    'images/galeria/28.jpeg',
    'images/galeria/29.jpeg',
    'images/galeria/30.jpeg',
    'images/galeria/31.jpeg',
    'images/galeria/32.jpeg'
];

// Índice da imagem atual no modal
let currentIndex = 0;

// Função para abrir o modal
function openModal(imgSrc, index) {
    document.getElementById('modalImage').src = imgSrc;
    currentIndex = index;
    document.getElementById('galleryModal').style.display = 'block';
    document.body.style.overflow = 'hidden'; // Impede o scroll do corpo quando o modal está aberto
}

// Função para fechar o modal
function closeModal() {
    document.getElementById('galleryModal').style.display = 'none';
    document.body.style.overflow = 'auto'; // Restaura o scroll do corpo
}

// Função para navegar para o próximo/anterior slide
function plusSlides(n) {
    currentIndex = (currentIndex + n + galleryImages.length) % galleryImages.length;
    document.getElementById('modalImage').src = galleryImages[currentIndex];
}

// Script para inicializar quando o DOM estiver pronto
document.addEventListener("DOMContentLoaded", function() {
    // Inicialização do AOS se existir
    if (typeof AOS !== 'undefined') {
        AOS.init({
            duration: 800,
            once: true,
            offset: 100
        });
    }
    
    // Configuração do filtro da galeria
    setupGalleryFilters();
    
    // Adiciona eventos de teclado para navegação
    document.addEventListener('keydown', function(e) {
        const galleryModal = document.getElementById('galleryModal');
        
        // Só processa se o modal estiver aberto
               if (galleryModal && galleryModal.style.display === 'block') {
            if (e.key === 'ArrowLeft' || e.key === 'Left') {
                plusSlides(-1); // Slide anterior
            } 
            else if (e.key === 'ArrowRight' || e.key === 'Right') {
                plusSlides(1); // Próximo slide
            }
            else if (e.key === 'Escape') {
                closeModal(); // Fechar modal
            }
        }
    });

    // Detecta cliques fora do conteúdo do modal para fechá-lo
    window.addEventListener('click', function(event) {
        const galleryModal = document.getElementById('galleryModal');
        const modalContent = document.querySelector('.modal-content');
        
        if (galleryModal && event.target === galleryModal) {
            closeModal();
        }
    });
});

// Função para configurar os filtros da galeria
function setupGalleryFilters() {
    const filterButtons = document.querySelectorAll('.filter-btn');
    const galleryItems = document.querySelectorAll('.gallery-item');
    
    filterButtons.forEach(button => {
        button.addEventListener('click', () => {
            // Remove a classe ativa de todos os botões
            filterButtons.forEach(btn => btn.classList.remove('active'));
            
            // Adiciona a classe ativa ao botão atual
            button.classList.add('active');
            
            // Obtém o filtro selecionado
            const filter = button.getAttribute('data-filter');
            
            // Filtra os itens da galeria
            galleryItems.forEach(item => {
                if (filter === 'all' || item.classList.contains(filter)) {
                    item.style.display = 'block';
                    setTimeout(() => {
                        item.style.opacity = '1';
                        item.style.transform = 'scale(1)';
                    }, 50);
                } else {
                    item.style.opacity = '0';
                    item.style.transform = 'scale(0.8)';
                    setTimeout(() => {
                        item.style.display = 'none';
                    }, 300);
                }
            });
        });
    });
}
</script>

<?php include 'footer.php'; ?>